@extends('admin_master')
@section('content')
 <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>General Form</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">General Form</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12">
          	 <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Add Product</h3>
              </div>

              @if (count($errors) > 0)
               <div class = "alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
            @endif
              <!-- /.card-header -->
              <!-- form start -->
              <form action="{{route('products.store')}}" enctype="multipart/form-data" method="post">
              	@csrf
                <div class="card-body">
                 <div class="row">
                   <div class="col-md-4">
                   	 <div class="form-group">
	                    <label for="product_name">Product Name</label>
	                    <input type="text" name="product_name" class="form-control" id="product_name" placeholder="Product Name" required="">
	                  </div>
                   </div>

                   <div class="col-md-4">
                   	  <div class="form-group">
                   	  	<label for="type_id">Select Type</label>
                   	  	<select class="form-control" id="type_id" name="type_id" required="">
                   	  	  <option value="" selected="" disabled="">Choose Type</option>
                   	  	  @foreach($types as $type)
                   	  	    <option value="{{$type->id}}">{{$type->title}}</option>
                   	  	  @endforeach
                   	  	</select>
                   	  </div>
                   </div>


                   <div class="col-md-4">
                   	  <div class="form-group">
		                  <label for="category_id">Select Category</label>
		                  <select class="form-control select2" name="category_id" style="width: 100%;" id="category_id">
		                    <option value="" selected="" disabled="">Choose Category</option>
		                    @foreach($categories as $category)
		                      <option value="{{$category->id}}">{{$category->title}}</option>
		                    @endforeach	
		                  </select>
		                </div>
                   </div>

                   <div class="col-md-4">
                   	 <div class="form-group">
                   	 	<label for="product_price">Product Price</label>
                   	 	<input type="number" class="form-control" id="product_price" name="product_price" placeholder="Product Price" required="">
                   	 </div>
                   </div>

                   <div class="col-md-4">
                   	 <div class="form-group">
                   	 	<label for="product_unit">Product Unit</label>
                   	 	<input type="text" class="form-control" id="product_unit" name="product_unit" placeholder="Product Unit" required="">
                   	 </div>
                   </div>

                   <div class="col-md-4">
                   	 <div class="form-group">
                   	 	<label for="interest_rate">Interest Rate (%)</label>
                   	 	<input type="number" class="form-control" id="interest_rate" name="interest_rate" placeholder="Interest Rate (%)" value="0">
                   	 </div>
                   </div>



                   <div class="col-md-4">
                   	 <div class="form-group">
                   	 	<label for="address">Address</label>
                   	 	<input type="text" class="form-control" id="address" name="address" placeholder="Address" required="">
                   	 </div>
                   </div>

                   <div class="col-md-4">
                   	 <div class="form-group">
                   	 	<label for="duration">Duration</label>
                   	 	<input type="text" class="form-control" id="duration" name="duration" placeholder="Duration" required="">
                   	 </div>
                   </div>

                   <div class="col-md-4">
                   	 <div class="form-group">
                   	 	<label for="duration_unit">Duration Unit</label>
                   	 	<select class="form-control" name="duration_unit" id="duration_unit" required=""> 
                   	 	  <option value="" selected="" disabled="">Choose duration unit</option>
                   	 	  <option value="day">Day</option>
                   	 	  <option value="week">Week</option>
                   	 	  <option value="month">Month</option>
                   	 	  <option value="year">Year</option>
                   	 	</select>
                   	 </div>
                   </div>


                   <div class="col-md-12">
                   	 <div class="form-group">
                   	 	<label for="description">Description</label>
	                     <textarea class="ckeditor form-control" name="description" required=""></textarea>
                   	 </div>
                   </div>


                 </div>
                  

                  <div class="row">
                  	<div class="col-md-6">
                  		<div class="form-group">
	                    <label for="image">Image</label>
	                    <div class="input-group">
	                      <div class="custom-file">
	                        <input type="file" name="image" class="custom-file-input"   accept="image/*"  required onchange="readURL(this);" required="">
	                        <label class="custom-file-label" for="image">Choose file</label>
	                      </div>
	                      <div class="input-group-append">
	                        <span class="input-group-text">Upload</span>
	                      </div>
	                    </div>
	                  </div>
                  	</div>

                  	<div class="col-md-6">
                  	  <div class="form-group">
                  	  	 <img src="" id="image" style="width: 60px; height: 60px; margin-top: 20px; border-radius: 50%; display: none;">
                  	  </div>
                  	</div>
                  </div>
                </div>
                <!-- /.card-body -->

                <div class="card-footer">
                  <button type="submit" class="btn btn-primary">Add Product</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
 </div>

 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
 <script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

 <script>
 	$(document).ready(function() {
       $('.ckeditor').ckeditor();

    });

    $(document).ready(function(){
    	$(document).on('input', '#total_booking', function(){
    		var total_booking = $(this).val();
    		$('#remaining_booking').val(total_booking);
    	});
    });

 	function readURL(input) {
      if (input.files && input.files[0]) {
      	$('#image').css('display', 'block');
          var reader = new FileReader();
          reader.onload = function (e) {
              $('#image')
                  .attr('src', e.target.result)
                  .width(60)
                  .height(60);
          };
          reader.readAsDataURL(input.files[0]);
      }
   }

 </script>
@endsection