<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->integer('category_id');
            $table->integer('type_id');
            $table->string('interest_rate')->nullable();
            $table->string('product_name');
            $table->string('product_price');
            $table->string('product_unit')->nullable();
            $table->string('duration');
            $table->enum('duration_unit', ['day', 'month', 'week', 'year']);
            $table->string('total_booking');
            $table->string('maximum_booking');
            $table->string('remaining_booking')->nullable();
            $table->text('address');
            $table->text('description');
            $table->string('image');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
