<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
class FaqController extends Controller
{   

     public function __construct()
    {
        $this->middleware('auth_check');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
          $faqs = DB::table('faqs')->orderBy('id','DESC')->get();
          return view('faqs.index', compact('faqs'));   
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('faqs.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            $request->validate([
                   'title' => 'required|string|unique:faqs',
                   'description' => 'required',
            ]);

            $data = array();
            $data['title'] = $request->title;
            $data['description'] = $request->description;
            DB::table('faqs')->insert($data);
            $notification=array(
                         'messege'=>'Successfully FAQ Added',
                         'alert-type'=>'success'
                        );
                return redirect()->back()->with($notification);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try{
           $faq = DB::table('faqs')->where('id',$id)->first();
           return view('faqs.edit', compact('faq'));
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
          $faq = DB::table('faqs')->where('id',$id)->first();
          $request->validate([
                   'title' => 'required|string|unique:faqs,title,'.$id,
                   'description' => 'required',
            ]);   
          $data = array();
          $data['title'] = $request->title;
          $data['description'] = $request->description;
          DB::table('faqs')->where('id',$id)->update($data);
          $notification=array(
                         'messege'=>'Successfully FAQ Updated',
                         'alert-type'=>'success'
                        );
         return redirect()->back()->with($notification);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
          DB::table('faqs')->where('id',$id)->delete();
          return response()->json('deleted');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
            }
    }
}
