<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AccessController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\FaqController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\SettingController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
	    return view('admin_login');
	});
	
Route::get('/payment-success', function(){
    return view('payment_success');
});
	
Route::group(['middleware' => 'prevent-back-history'],function(){
	

	Route::post('/admin-login', [AccessController::class, 'adminLogin']);
	Route::get('/logout', [AccessController::class, 'logout']);
	//admin 
	  //dashboard
	Route::get('/dashboard', [DashboardController::class, 'dashboard']);

	//category
	Route::resource('categories', CategoryController::class);
	Route::get('/get-categories', [CategoryController::class, 'categoryPaginate']);
	Route::get('/search-category', [CategoryController::class, 'searchCategory']);

	//product
	Route::resource('products', ProductController::class);
	Route::get('/search-product', [ProductController::class, 'searchProduct']);
	Route::get('/get-products', [ProductController::class, 'productPaginate']);

	//orders
	Route::get('/order-lists', [OrderController::class, 'orderLists']);
	Route::get('get-orders', [OrderController::class, 'getOrders']);

	//News
	Route::resource('news', NewsController::class);

	//blog
	Route::resource('blogs', BlogController::class);
	Route::post('ckeditor/upload', [BlogController::class, 'upload'])->name('ckeditor.upload');

	//change password
	Route::get('/change-password', [SettingController::class, 'changePassword']);
	Route::post('passoword-update', [SettingController::class, 'passwordUpdate']);

	//faq
	Route::resource('faqs', FaqController::class);

});