@extends('admin_master')
@section('content')
 <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>General Form</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">General Form</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12">
          	 <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Add Category</h3>
              </div>

              @if (count($errors) > 0)
               <div class = "alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
            @endif
              <!-- /.card-header -->
              <!-- form start -->
              <form action="{{route('categories.store')}}" enctype="multipart/form-data" method="post">
              	@csrf
                <div class="card-body">
                  <div class="form-group">
                    <label for="title">Category Name</label>
                    <input type="text" name="title" class="form-control" id="title" placeholder="Category Name" required="" value="{{$category->title}}">
                  </div>
                  <div class="row">
                  	<div class="col-md-6">
                  		<div class="form-group">
	                    <label for="image">Image</label>
	                    <div class="input-group">
	                      <div class="custom-file">
	                        <input type="file" name="image" class="custom-file-input"   accept="image/*"  required onchange="readURL(this);" required="">
	                        <label class="custom-file-label" for="image">Choose file</label>
	                      </div>
	                      <div class="input-group-append">
	                        <span class="input-group-text">Upload</span>
	                      </div>
	                    </div>
	                  </div>
                  	</div>

                  	<div class="col-md-6">
                  	  <div class="form-group">
                  	  	 <img src="{{URL::to('public/'.$category->image)}}" id="image" style="width: 60px; height: 60px; margin-top: 20px; border-radius: 50%;">
                  	  </div>
                  	</div>
                  </div>
                </div>
                <!-- /.card-body -->

                <div class="card-footer">
                  <button type="submit" class="btn btn-primary">Update</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
 </div>

 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
 <script>
 	function readURL(input) {
      if (input.files && input.files[0]) {
          var reader = new FileReader();
          reader.onload = function (e) {
              $('#image')
                  .attr('src', e.target.result)
                  .width(60)
                  .height(60);
          };
          reader.readAsDataURL(input.files[0]);
      }
   }

 </script>
@endsection