<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
class OrderController extends Controller
{   

   public function __construct()
    {
        $this->middleware('auth_check');
    }
    
    public function orderLists()
    {
    	try{
    	  $orders = DB::table('orders')
    	              ->join('carts', 'orders.order_session_id', 'carts.cart_session_id')
    	              ->join('products', 'carts.product_id', 'products.id')
    	              ->join('users', 'orders.user_id', 'users.id')
    	              ->select('orders.*', 'carts.cart_qty', 'carts.cart_total', 'products.product_name', 'products.product_price', 'users.name', 'users.phone', 'products.product_unit')
    	              ->orderBy('orders.id','DESC')
    	              ->paginate(10);
    	   $total = DB::table('carts')->sum('cart_total');
    	  return view('orders.index', compact('orders', 'total'));
    	}catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    public function getOrders(Request $request)
    {
        try{
          if(!empty($request->start_date) && !empty($request->end_date) && $request->status != 'all')
          {
             $orders = DB::table('orders')
                      ->join('carts', 'orders.order_session_id', 'carts.cart_session_id')
                      ->join('products', 'carts.product_id', 'products.id')
                      ->join('users', 'orders.user_id', 'users.id')
                      ->select('orders.*', 'carts.cart_qty', 'carts.cart_total', 'products.product_name', 'products.product_price', 'users.name', 'users.phone', 'products.product_unit')
                      ->where('orders.date', '>=', $request->start_date)
                      ->where('orders.date', '<=', $request->end_date)
                      ->where('orders.status', $request->status)
                      ->orderBy('orders.id','DESC')
                      ->paginate(10);
          }
          elseif(!empty($request->start_date) && !empty($request->end_date) && $request->status == 'all')
          {
             $orders = DB::table('orders')
                      ->join('carts', 'orders.order_session_id', 'carts.cart_session_id')
                      ->join('products', 'carts.product_id', 'products.id')
                      ->join('users', 'orders.user_id', 'users.id')
                      ->select('orders.*', 'carts.cart_qty', 'carts.cart_total', 'products.product_name', 'products.product_price', 'users.name', 'users.phone', 'products.product_unit')
                      ->where('orders.date', '>=', $request->start_date)
                      ->where('orders.date', '<=', $request->end_date)
                      ->orderBy('orders.id','DESC')
                      ->paginate(10);
          }

          elseif(empty($request->start_date) && empty($request->end_date) && $request->status != 'all')
          {
             $orders = DB::table('orders')
                      ->join('carts', 'orders.order_session_id', 'carts.cart_session_id')
                      ->join('products', 'carts.product_id', 'products.id')
                      ->join('users', 'orders.user_id', 'users.id')
                      ->select('orders.*', 'carts.cart_qty', 'carts.cart_total', 'products.product_name', 'products.product_price', 'users.name', 'users.phone', 'products.product_unit')
                      ->where('orders.status', $request->status)
                      ->orderBy('orders.id','DESC')
                      ->paginate(10);
          }
          else
          {
              $orders = DB::table('orders')
                      ->join('carts', 'orders.order_session_id', 'carts.cart_session_id')
                      ->join('products', 'carts.product_id', 'products.id')
                      ->join('users', 'orders.user_id', 'users.id')
                      ->select('orders.*', 'carts.cart_qty', 'carts.cart_total', 'products.product_name', 'products.product_price', 'users.name', 'users.phone', 'products.product_unit')
                      ->orderBy('orders.id','DESC')
                      ->paginate(10);
          }
          if(count($orders) > 0)
          {  
             return view('orders.paginate', compact('orders'));
             
          }
          else
          {
             echo "no_data";
          }
          

        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
}
