<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
class NewsController extends Controller
{   

   public function __construct()
    {
        $this->middleware('auth_check');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
          $news = DB::table('news')->orderBy('id','DESC')->get();
          return view('news.index', compact('news'));
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('news.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
          $request->validate([
                   'title' => 'required|string',
                   'url' => 'required|url',
                   'source' => 'required|string',
                   'image' => 'required',
           ]);

          $data = array();
          $file = $request->file('image');
          $name = time().$file->getClientOriginalName();
          $file->move(public_path().'/uploads/news/', $name);  
          $path= 'uploads/news/'.$name; 
          $data['title'] = $request->title;
          $data['url'] = $request->url;
          $data['source'] = $request->source;
          $data['image'] = $path;
          $data['date'] = date('Y-m-d');
          $data['date_two'] = date('d F Y');
          DB::table('news')->insert($data);
          $notification=array(
                         'messege'=>'Successfully News Added',
                         'alert-type'=>'success'
                        );
         return redirect()->back()->with($notification);
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try{
          $news = DB::table('news')->where('id',$id)->first();
          return view('news.edit', compact('news'));
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
          $news = DB::table('news')->where('id',$id)->first();
          $request->validate([
                   'title' => 'required|string',
                   'url' => 'required|url',
                   'source' => 'required|string',
           ]);

          $data = array();
          if($request->file('image'))
          {
              $file = $request->file('image');
              $name = time().$file->getClientOriginalName();
              $file->move(public_path().'/uploads/news/', $name);  
              $path= 'uploads/news/'.$name;
              $data['image'] = $path;

              unlink(public_path($news->image));
          }
          else
          {
            $data['image'] = $news->image;
          }
          $data['title'] = $request->title;
          $data['url'] = $request->url;
          $data['source'] = $request->source;
          $data['date'] = date('Y-m-d');
          $data['date_two'] = date('d F Y');
          DB::table('news')->where('id',$id)->update($data);
          $notification=array(
                         'messege'=>'Successfully News Updated',
                         'alert-type'=>'success'
                        );
         return redirect()->back()->with($notification);
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $news = DB::table('news')->where('id',$id)->first();  
            unlink(public_path($news->image)); 
            DB::table('news')->where('id',$id)->delete();
            return response()->json('deleted');
        }catch(Exception $e){
              
            $message = $e->getMessage();
  
            $code = $e->getCode();       
  
            $string = $e->__toString();       
            return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
            exit;
        }
    }
}
